This library provides utility methods to generate and sign Knox Tokens using server side Javascript. The pre-requisites for using this utility are

  - You have downloaded the Knox Certificate file (certificate.json)
  - You have generated a Client Identifier (api-key) for accessing apis of Knox Cloud Services.

# Intended Use
The workflow for making api calls to Knox Cloud Services is divided into a portal workflow, and a programmatic workflow.

### Portal flow
 1. Download Certificate from Knox Api Portal
 2. Generate and Download ClientIdentifier (api-key) for a specific Knox Solution

### Programmatic flow
3. Call Knox api to generate an Api Access Token. This api call requires a **signed ClientIdentifier**, and specific contents of your Certificate (Public Key).
4. Call Knox api for your intended workflow (eg: upload device, configure device etc). This api call requires your **signed Api Access Token**, and specific contents of your Certificate (Public Key).

This utility js library helps generate signed clientIdentifiers, and signed accessTokens.

### Install using npm
npm install knox-token-library-js

### Generate Signed ClientIdentifier

The following method is provided to generate a **signed client identifier**.
```
const knoxTokenLibraryJs = require('knox-token-library-js');
var signedClientId = knoxTokenLibraryJs.generateSignedClientIdentifierJWT("certificate.json", "my-client-identifier");
```
Input parameters:
- certificate: An input stream of the Knox certificate (certificate.json) that was downloaded from Knox Api portal.
- clientIdentifier: The string ClientIdentifier downloaded from Knox Api portal.

Output:
- A String representing the ClientIdentifier signed with the primary key from the downloaded Certificate.

### Generate Signed Api Access Token

KnoxTokenUtility class provides the following method to generate a **signed api access token**.
```
const knoxTokenLibraryJs = require('knox-token-library-js');
var signedAccessToken = knoxTokenLibraryJs.generateSignedAccessTokenJWT("certificate.json", "my-access-token");
```
Input parameters:
- certificate: An input stream of the Knox certificate (certificate.json) that was downloaded from Knox Api portal.
- accessToken: The string api AccessToken returned by calling Knox Cloud Services' generateAccessToken api.

Output:
- A String representing the AccessToken signed with the primary key from the downloaded Certificate.

License
----

Apache
